/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.documentation;

import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocCategory;
import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.hollingsworth.arsnouveau.api.registry.DocumentationRegistry;
import com.hollingsworth.arsnouveau.client.gui.documentation.BaseDocScreen;
import com.hollingsworth.arsnouveau.client.gui.documentation.DocSectionButton;
import com.hollingsworth.arsnouveau.client.gui.documentation.EntriesScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class IndexScreen
extends BaseDocScreen {
    List<DocCategory> categoryList;
    List<DocSectionButton> sections = new ArrayList<DocSectionButton>();

    public IndexScreen(Collection<DocCategory> categories) {
        this.categoryList = new ArrayList<DocCategory>(categories);
        this.maxArrowIndex = (this.categoryList.size() - 1) / 5;
    }

    public IndexScreen() {
        this(DocumentationRegistry.getMainCategoryMap().values().stream().sorted().toList());
    }

    @Override
    public void init() {
        super.init();
        this.initSections();
    }

    public static void open() {
        Minecraft.getInstance().setScreen((Screen)new IndexScreen());
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        DocClientUtils.blit(graphics, DocAssets.SPLASH_FRAME, this.screenLeft + 19 - 3, this.screenTop + 17 - 5);
        DocClientUtils.drawHeader((Component)Component.translatable((String)"ars_nouveau.doc.categories"), graphics, this.screenLeft + 153, this.screenTop + 17, 135, mouseX, mouseY, partialTicks);
        DocClientUtils.drawParagraph((Component)Component.translatable((String)"ars_nouveau.documentation.intro1"), graphics, this.screenLeft + 19 + 6, this.screenTop + 17 + 20, 106, mouseX, mouseY, partialTicks);
        DocClientUtils.drawParagraph((Component)Component.translatable((String)"ars_nouveau.documentation.intro2"), graphics, this.screenLeft + 19 + 6, this.screenTop + 17 + 85, 106, mouseX, mouseY, partialTicks);
    }

    public void initSections() {
        for (DocSectionButton section : this.sections) {
            this.removeWidget((GuiEventListener)section);
        }
        this.sections.clear();
        List<DocCategory> sliced = this.categoryList.subList(this.arrowIndex * 5, Math.min((this.arrowIndex + 1) * 5, this.categoryList.size()));
        for (int i = 0; i < sliced.size(); ++i) {
            DocCategory category = sliced.get(i);
            DocSectionButton button = new DocSectionButton(this.screenLeft + 18 + 135, this.screenTop + 34 + 28 * i, category.getTitle(), category.renderIcon(), b -> {
                if (!category.subCategories().isEmpty()) {
                    this.transition(new IndexScreen(category.subCategories()));
                } else {
                    this.transition(new EntriesScreen(category));
                }
            });
            this.addRenderableWidget((GuiEventListener)button);
            this.sections.add(button);
        }
    }

    @Override
    public void onArrowIndexChange() {
        super.onArrowIndexChange();
        this.initSections();
    }
}

